***************************************************************
*  Script to draw boxs
*    Usage: run drawbox data_file
*    data format:    id[i] lon0[i] lon1[i] lat0[i] lat1[i]
*                                     Aug 06, 1999 Shin Satoh
***************************************************************

function drawline (args)

if (args='') 
  say 'Usage: run drawline data_file str_size'
  return
endif

fname = subwrd(args,1)
ssize = subwrd(args,2)
if (ssize='');   ssize=0.07;   endif
lcol=1
lsty=1
lthick=4
say 'drawboxs: 'fname'  color='lcol'  style='lsty'  thickness='lthick

'set line 'lcol' 'lsty' 'lthick
'set string 1 bc 'lthick
'set strsiz 'ssize

while (1)

  ret = read(fname)
  rc = sublin(ret,1)
  if (rc>0) 
    break
  endif
  rec = sublin(ret,2)
  id  = subwrd(rec,1)
  lon0 = subwrd(rec,2)
  lon1 = subwrd(rec,3)
  lat0 = subwrd(rec,4)
  lat1 = subwrd(rec,5)

  'q w2xy 'lon0' 'lat0
  posxy = result
  x0 = subwrd(posxy,3)
  y0 = subwrd(posxy,6)

  'q w2xy 'lon1' 'lat1
  posxy = result
  x1 = subwrd(posxy,3)
  y1 = subwrd(posxy,6)

  xc = x0+(x1-x0)*0.5
  yc = y0+(y1-y0)*0.5-ssize*0.5
  'draw rec 'x0' 'y0' 'x1' 'y1
  'draw string 'xc' 'yc' 'id

endwhile
