***************************************************************
*  Script to draw lines
*    Usage: run drawline data_file [color] [style] [thickness]
*    * If specified style !=1 & data flag=1 then use the style
*    data format:    x[i] y[i] flag[i]
*          flag=0: start/skip
*               1:  draw line using the default style
*               2-7: forced line style (same as GrADS line style)
*                   (1 - solid)
*                    2 - long dash
*                    3 - short dash
*                    4 - long,short dashed
*                    5 - dotted
*                    6 - dot dash
*                    7 - dot dot dash 
*
*            11-15 : mark (GrADS original marktype +10)
*                   11(1) - crosshair 
*                   12(2) - open circle 
*                   13(3) - closed circle 
*                   14(4) - open square 
*                   15(5) - closed square
*
*                                     Aug 10, 1999 Shin Satoh
***************************************************************

function drawline (args)

if (args='') 
  say 'Usage: run drawline data_file color style thickness'
  return
endif

fname = subwrd(args,1)
lcol  = subwrd(args,2)
lsty  = subwrd(args,3)
lthick= subwrd(args,4)
if (lcol='');   lcol=1;   endif
if (lsty='');   lsty=1;   endif
if (lthick=''); lthick=6; endif
say 'drawline.gs: 'fname'  color='lcol'  style='lsty'  thickness='lthick
'set line 'lcol' 'lsty' 'lthick
f0 = lsty

while (1)

  ret = read(fname)
  rc = sublin(ret,1)
  if (rc>0) 
    break
  endif
  rec = sublin(ret,2)
  lon = subwrd(rec,1)
  lat = subwrd(rec,2)
  f   = subwrd(rec,3)

  'q w2xy 'lon' 'lat
  posxy = result
  x = subwrd(posxy,3)
  y = subwrd(posxy,6)

  if (fold!=f) 
      say 'drawline.gs: change style='f' x='lon' y='lat
  endif
  if (f!=f0 & 2<=f & f<=7) 
     'set line 'lcol' 'f' 'lthick
  endif

  if (f!=0)
    'draw line 'xold' 'yold' 'x' 'y
  endif
  if (f>=11)
     mtype=f-10
     say 'mark='mtype' x='lon' y='lat
    'draw mark 'mtype' 'x' 'y' 0.08'
  endif
  xold = x
  yold = y
  fold = f

endwhile
