***************************************************************
*  Script to draw mark and string
*    Usage: run drawmark data_file [color] [style] [thickness]
*    data format:    x[i] y[i] mark[i] name[i] name2[i]
*         1-11 : mark (GrADS original marktype)
*         1) - crosshair 
*         2) - open circle   3) - closed circle 
*         4) - open square   5) - closed square
*         6) - X             7) - diamond 
*         8) - triangle      9) - none 
*        10) - open circle with vertical line 
*        11) - open oval
*
*                                     Dec 18, 2000 Shin Satoh
***************************************************************

function drawmark (args)

if (args='') 
  say 'Usage: run dramark data_file [size] [color] [style] [thickness]'
  return
endif

fname = subwrd(args,1)
*--- for set string ---
ssize  = subwrd(args,2)
if (ssize='');  ssize=0.1;  endif
srotat = 0.0
*--- for set line ---
lcol  = subwrd(args,3)
lsty  = subwrd(args,4)
lthick= subwrd(args,5)
if (lcol='');   lcol=1;    endif
if (lsty='');   lsty=1;    endif
if (lthick=''); lthick=5;  endif
say '# drawmark.gs: 'fname'  size='ssize'  color='lcol'  style='lsty'  thickness='lthick
'set line 'lcol' 'lsty' 'lthick
'set string 'lcol' tl 'lthick' 'srotat 
'set strsiz 'ssize

while (1)
  ret = read(fname)
  rc = sublin(ret,1)
  if (rc>0) 
    break
  endif
  rec = sublin(ret,2)
  lon = subwrd(rec,1)
  lat = subwrd(rec,2)
  mtype = subwrd(rec,3)
  name1 = subwrd(rec,4)
  name2 = subwrd(rec,5)
*say '# drawmark.gs: 'lon' 'lat' 'mtype' 'name1' 'name2

*--- get xy-position and draw the mark ----
  'q w2xy 'lon' 'lat
  posxy = result
  x = subwrd(posxy,3)
  y = subwrd(posxy,6)
  if (mtype!=0)
    'draw mark 'mtype' 'x' 'y' 'ssize
  endif

*--- draw the string ---
  y1 = y - ssize*0.6
  y2 = y - ssize*1.8
*  if (name1!="")
*    'draw string  'x' 'y1' 'name1
*  endif
*  if (name2!="")
*    'draw string  'x' 'y2' 'name2
*  endif

endwhile
