***************************************************************
*  Script to display GSIMAP <for portrait>
*    japan_sea_all.gs to display the WMO2001 map
*    usage: grads -pc "run japan_sea_all.gs"
*                                     Dec 19, 2000 Shin Satoh
***************************************************************

function drawline (args)

if (args='') 
  say 'Usage: run japan_sea lon0 lon1 lat0 lat1'
endif

lon0 = subwrd(args,1)
lon1 = subwrd(args,2)
lat0 = subwrd(args,3)
lat1 = subwrd(args,4)
if (lon0='');  lon0=126.0;  endif
if (lon1='');  lon1=144.0;  endif
if (lat0='');  lat0=32.0;   endif
if (lat1='');  lat1=48.0;   endif
say 'set lon 'lon0' 'lon1'  set lat 'lat0' 'lat1

'open japan_gsimap.ctl'
'set mpdset hires'
'set mproj on'

'set grads off'
'set gxout shaded'
'set parea 0.5 8.0 2.0 10.5'
'set lon 'lon0' 'lon1
'set lat 'lat0' 'lat1

'set clevs 0 100 200 500 1000 1500 2000'
'set rbcols 0 10 7 12 8 2 6 9'
'd alt'
'run cbarn 0.6 0 6.0 1.8'

'run drawline wmo_grid_all 15 1 1'
'run drawline wmo_area_all 1 1 2'
'run drawline wmo_g150 1 1 1'
'run drawmark wmo_site'
'run drawmark wmo_point'
