*----------------------------------------------------------
*  GrADS script for landscape
*                              June 07, 2002  Shin Satoh
*----------------------------------------------------------
function profs (args)

if (args='')
  say 'usage: ga>open x2a25_8329.ctl (OK-SL)'  
  say '       ga>run zlhret_profs SCAN_NO ANGLE_BIN_NO'
  say 'Enter SCAN_NO ANGLE_BIN_NO:'
  pull args
endif

scanno = subwrd(args,1)
angbin = subwrd(args,2)
if (scanno<1); scanno=1; endif;
if (angbin<1); angbin=24; endif;

'c'
'set vpage 0 11 0 8.5'
'set mproj off'
'set grads off'
'set xlopts 1 4 0.14'
'set ylopts 1 4 0.14'
'set gxout shaded'

'set y 'angbin
'set z 1 57'
'set t 'scanno

*----- Upper left (qp-prof) -----
'set parea 1 5 5.5 7.5'
'set ylevs 0 2 4 6 8 10 12 14'

'set vrange 0.0 5.0'
'set cmark 0'
'set ccolor 2'
'd qp*1e3*10.0'
'set cmark 0'
'set ccolor 1'
'd qp*1e3'
'set string 1 tl 8'
'set strsiz 0.18'
'draw string 1.2 7.4 qp [g/kg]          (a)'

*----- Middle left (Vt-prof) -----
'set parea 1 5 3.0 5.0'
'set ylevs 0 2 4 6 8 10 12 14'

'set vrange -8.0 0.0'
'set cmark 0'
'set ccolor 1'
'd vt'

'set string 1 tl 8'
'set strsiz 0.18'
'draw string 1.2 4.9 Vt [m/s]           (b)'

*------- Bottom left (Rain-prof) ----------------
'set parea 1 5 0.5 2.5'
'set ylevs 0 2 4 6 8 10 12 14'

'set vrange 0.0 100.0'
'set cmark 0'
'set ccolor 2'
'd rain*10.0'
'set cmark 0'
'set ccolor 1'
'd rain'

'set string 1 tl 8'
'set strsiz 0.18'
'draw string 1.2 2.4 Rain [mm/hr]      (c)'


*----- Upper right (Fqp-prof) -----
'set parea 6 10 5.5 7.5'
'set ylevs 0 2 4 6 8 10 12 14'

'set vrange -0.01 0.03'
'set cmark 0'
'set ccolor 2'
'd fqp*1e3*10.0'
'set cmark 0'
'set ccolor 1'
'd fqp*1e3'
'set line 1 1 4'
'draw line 7.0 5.5 7.0 7.5'

'set string 1 tl 8'
'set strsiz 0.18'
'draw string 6.2 7.4 Fqp [g/kg/s]      (d)'

*----- middle right (w-prof) -----
'set parea 6 10 3.0 5.0'
'set ylevs 0 2 4 6 8 10 12 14'

'set vrange -4 12'
'set cmark 0'
'set ccolor 2'
'd w*10.0'
'set cmark 0'
'set ccolor 1'
'd w'
'set line 1 1 4'
'draw line 7.0 3.0 7.0 5.0'

'set string 1 tl 8'
'set strsiz 0.18'
'draw string 6.2 4.9 w [m/s]            (e)'

*----- Bottom right (LH-prof) -----
'set parea 6 10 0.5 2.5'
'set ylevs 0 2 4 6 8 10 12 14'

'set vrange -20 20'
'set cmark 0'
'set ccolor 2'
'd lh*10.0'
'set cmark 0'
'set ccolor 1'
'd lh'
'set line 1 1 4'
'draw line 8.0 0.5 8.0 2.5'

'set string 1 tl 8'
'set strsiz 0.18'
'draw string 6.2 2.4 LH [K/hr]           (f)'

return