/**********************************************************
                                 May 30, 2002  Shin Satoh
FUNCTION: int cld_ht()
SOURCE FILE: cld_ht.c
PURPOSE: Estimate cloud top and bottom height

CALLING SEQUENCE:
    (I) float cze[][49]    : reflectivity factor [dBZ]
    (I) float *flag_rain   : rain flag (NO_RAIN=0., POSSIBLE=1., CERTAIN=2.)
    (I) float *flag_rtype  : rain type flag (STRAT=0., CONV=1., OTHERS=2.)
    (I) int   *rbinNum     : range bin numbers of top[0], bottom[1],surface[2], 
                                              BB[3],PIZ_threshold[4], ZeMax[5]
    (O) float *cldt        : cloud top height [km]
    (O) float *cldb        : cloud bottom height [km]
    (O) float *trop        : tropopause height [km]

RETURN: 0
************************************************************/
#include <math.h>
#include <stdio.h>

#define  YDIM      49      /* number of angle bins in output */
#define  ZDIM      80      /* number of vertical bins in output */
#define  ZRESO      0.25   /* vertical resolution in km */
#define  ZEMIN     15.0    /* minimum reflectivity [dBZ] (actually 17 dBZ, but...) */

int cld_ht (float cze[][YDIM], float *flag_rain, float *flag_rtype, 
            int *rbinNum, float *cldt, float *cldb, float *trop)
{
        int    i, j, k;
        float  ztop, zbot;

    /* get tropopause height */
        for(j=0; j<YDIM; j++){
	  trop[j]=14.0;        /* tentative !!!! */       
        }

    /* get echo top & bottom height [km] */
    /* --- should continue more than 3 range bins --- */
        for(j=0; j<YDIM; j++){
          ztop = cldt[j];
          zbot = cldb[j];
	  for(k=0; k<ZDIM-3; k++){
            if(cze[k][j]>ZEMIN &&
               cze[k+1][j]>ZEMIN &&
               cze[k+2][j]>ZEMIN   ){ 
                 ztop = (k+2)*ZRESO; 
            }
          }
          if(flag_rtype[j] < 0.1) ztop +=1.0;                      /* strat */
          if(0.9<flag_rtype[j] && flag_rtype[j]<1.1) ztop +=0.25;  /* conv */
          if(1.9<flag_rtype[j] && flag_rtype[j]<2.1) ztop +=0.5;   /* others */
          if(trop[j] < ztop) trop[j] = ztop + 0.25;      /* penetrative conv */
          cldt[j]=ztop;

	  for(k=ZDIM-1; k>1; k--){
            if(cze[k][j]>ZEMIN &&
               cze[k-1][j]>ZEMIN &&
               cze[k-2][j]>ZEMIN   ){ 
                 zbot = (k-2)*ZRESO; 
            }
          }
          cldb[j]=zbot;
       }

       return 0;     
}
