/*************************************************************
   file name: g4pfunc.c

   compile: gcc -g -lm g4pfunc.c ggrads_ctl.c -o g4pfunc
   output: GrADS file and its control file

                                     Dec 11, 2001  Shin Satoh
***************************************************************/
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include "g4pfunc.h"

#define   ZRESO    0.25
#define   UNDEF    -999.9

int main(int argc, char *argv[])
{
/* --- common variables --- */
    int     i,j,k,irow,icol,lp,lp0;
    double  ztrop,zcldt,zmelt,z;
    float   **matrix_a,**matrix_b;
    static float  coef[5],wprof[21][101];

/* ---- GrADS output variables --- */    
    FILE    *fpg;
    char    g_name[256];
    static char   c_var[400], c_memo[128];
    int    nx, ny, nz, nt, size2d;
    int    iyear, imonth, iday, ihr, imin;
    double xmin, ymin, zmin, tmin, dx, dy, dz, dt, no_data;


/*=======================================================================*/
/* --- output file ---*/
    strcpy(g_name,"z4pf01");
    if((fpg = fopen(g_name,"w" )) == NULL ){
         printf("Output file open error!: %s \n",g_name); 
         exit(1);   
    }

/* --- alloc matrix of fourth_power_func ---*/
    matrix_a=matrix(1,3,1,3);
    matrix_b=matrix(1,3,1,1);


/* ------- Main loop ------- */
    for(lp=0; lp<21; lp++){
      if(0<=lp && lp<7){
	ztrop=16.0;
        zcldt=14.0;
        zmelt=4.0;
        lp0=0;
      }else if(7<=lp && lp<14){
	ztrop=16.0;
        zcldt=10.0;
        zmelt=4.0;
        lp0=7;
      }else if(14<=lp && lp<21){
	ztrop=16.0;
        zcldt=14.0;
        zmelt=0.01;
        lp0=14;
      }
   /* input matrix of simultaneous eqations */   
      matrix_a[1][1]=pow(ztrop,3.);
      matrix_a[1][2]=pow(ztrop,2.);
      matrix_a[1][3]=ztrop;
      matrix_a[2][1]=pow(zcldt,3.);
      matrix_a[2][2]=pow(zcldt,2.);
      matrix_a[2][3]=zcldt;
      matrix_a[3][1]=pow(zmelt,3.);
      matrix_a[3][2]=pow(zmelt,2.);
      matrix_a[3][3]=zmelt;

      matrix_b[1][1]=pow(ztrop,4.)*-1.0;
      matrix_b[2][1]=pow(zcldt,4.)*-1.0;
      matrix_b[3][1]=pow(zmelt,4.)*-1.0;

      /*
      printf("==== Input matrix ====\n");
      for(irow=1; irow<4; irow++){
        printf("%10.3f %10.3f %10.3f | %10.3f\n",
	       matrix_a[irow][1],matrix_a[irow][2],matrix_a[irow][3],matrix_b[irow][1]);
      }
      */

   /* solve the equations using Gauss-Jordan method */
      gaussj(matrix_a, 3, matrix_b, 1);

      /*
      printf("==== Result of Gauss-Jordan ====\n");
      for(irow=1; irow<4; irow++){
        printf("%10.3f %10.3f %10.3f | %10.3f\n",
	       matrix_a[irow][1],matrix_a[irow][2],matrix_a[irow][3],matrix_b[irow][1]);
      }
      */

      coef[1]=(float)(lp-lp0+1)*0.001;
      coef[2]=coef[1]*matrix_b[1][1];
      coef[3]=coef[1]*matrix_b[2][1];
      coef[4]=coef[1]*matrix_b[3][1];

      printf("No=%2d  Ztrop=%5.2f, Zcldt=%5.2f, Zmelt=%5.2f |  ",
              lp,ztrop,zcldt,zmelt);
      printf("a=%8.3f, b=%10.3f, c=%10.3f, d=%10.3f\n",
              coef[1],coef[2],coef[3],coef[4]);


   /* make w-prof */      
      for (k=0; k<101; k++) {
	z = (k-21)*ZRESO;    /* [km] */
        wprof[lp][k] = coef[1]*pow(z,4.) + coef[2]*pow(z,3.) + 
	               coef[3]*pow(z,2.) + coef[4]*z;
        /* printf("### z=%5.2f  w=%10.2f\n",z,wprof[k][lp]); */

      }

    } /* end of main loop */


    /* output GrADS file */
   

/* ------- Output GrADS file ------- */
        size2d = 101 * 21 * sizeof(float);
        fwrite(wprof,1,size2d,fpg);
        fclose(fpg);
        printf("output GrADS file (Dim= %d * %d)\n\n",101,21);

/* ------- output GrADS ctl file ------- */
        strcpy(c_memo,"W-prof in 4th power func");
        strcpy(c_var,"wprof");
        nx=101;          ny=21;      nz=1;      nt=1;
        xmin=-21*ZRESO;  ymin=1.0;  zmin=0.0;  tmin=0.0;
        dx=ZRESO;        dy=1.0;     dz=0.1;    dt=1.0;
        no_data= UNDEF;
        iyear  = 2001; 
        imonth = 1;
        iday   = 1;
        ihr    = 1;
        imin   = 1;

        ggrads_ctl( g_name, nx, ny, nz, nt, xmin, ymin, zmin, tmin,
                    dx, dy, dz, dt, no_data, ihr, imin, iday, imonth, iyear,
                    c_var, c_memo );

        return(0);




}
/*-------------------------------------------------------------------------------
    Function gauss-Jordan method
-------------------------------------------------------------------------------*/
#define NR_END 1
#define FREE_ARG char*
#define SWAP(a,b) {temp=(a);(a)=(b);(b)=temp;}

gaussj(float **a, int n, float **b, int m)
{
	int *indxc,*indxr,*ipiv;
	int i,icol,irow,j,k,l,ll;
	float big,dum,pivinv,temp;

	indxc=ivector(1,n);
	indxr=ivector(1,n);
	ipiv=ivector(1,n);
	for (j=1;j<=n;j++) {ipiv[j]=0;}
/* loop in row (i) */
	for (i=1;i<=n;i++) {
	  /* seek a pivot element */
	   big=0.0;
	   for (j=1;j<=n;j++) {
	      if (ipiv[j] != 1) {
		 for (k=1;k<=n;k++) {
		    if (ipiv[k] == 0) {
		       if (fabs(a[j][k]) >= big) {
			  big=fabs(a[j][k]);
			  irow=j;
			  icol=k;
		       }
		    } else if (ipiv[k] > 1) {nrerror("gaussj: Singular Matrix-1");}
		 }
	      }
	   }
	   ++(ipiv[icol]);

           /* change row and col */
	   if (irow != icol) {
	      for (l=1;l<=n;l++) {SWAP(a[irow][l],a[icol][l])}
	      for (l=1;l<=m;l++) {SWAP(b[irow][l],b[icol][l])}
	   }
	   indxr[i]=irow;
	   indxc[i]=icol;
	   if (a[icol][icol] == 0.0) {nrerror("gaussj: Singular Matrix-2");}
	   pivinv=1.0/a[icol][icol];
	   a[icol][icol]=1.0;
	   for (l=1;l<=n;l++) {a[icol][l] *= pivinv;}
	   for (l=1;l<=m;l++) {b[icol][l] *= pivinv;}
	   for (ll=1;ll<=n;ll++){
	      if (ll != icol) {
		 dum=a[ll][icol];
		 a[ll][icol]=0.0;
		 for (l=1;l<=n;l++) {a[ll][l] -= a[icol][l]*dum;}
		 for (l=1;l<=m;l++) {b[ll][l] -= b[icol][l]*dum;}
	      }
           }
	}
	/* replace into the original order */
	for (l=n;l>=1;l--) {
	   if (indxr[l] != indxc[l]) {
	      for (k=1;k<=n;k++) {
		 SWAP(a[k][indxr[l]],a[k][indxc[l]]);
              }
           }
	}
	free_ivector(ipiv,1,n);
	free_ivector(indxr,1,n);
	free_ivector(indxc,1,n);
}

void nrerror(char error_text[])
/* Numerical Recipes standard error handler */
{
	fprintf(stderr,"Numerical Recipes run-time error...\n");
	fprintf(stderr,"%s\n",error_text);
	fprintf(stderr,"...now exiting to system...\n");
	exit(1);
}


int *ivector(long nl, long nh)
/* allocate an int vector with subscript range v[nl..nh] */
{
	int *v;
	v=(int *)malloc((size_t) ((nh-nl+1+NR_END)*sizeof(int)));
	if (!v) nrerror("allocation failure in ivector()");
	return v-nl+NR_END;
}

float **matrix(long nrl, long nrh, long ncl, long nch)
/* allocate a float matrix with subscript range m[nrl..nrh][ncl..nch] */
{
	long i, nrow=nrh-nrl+1,ncol=nch-ncl+1;
	float **m;

	/* allocate pointers to rows */
	m=(float **) malloc((size_t)((nrow+NR_END)*sizeof(float*)));
	if (!m) nrerror("allocation failure 1 in matrix()");
	m += NR_END;
	m -= nrl;

	/* allocate rows and set pointers to them */
	m[nrl]=(float *) malloc((size_t)((nrow*ncol+NR_END)*sizeof(float)));
	if (!m[nrl]) nrerror("allocation failure 2 in matrix()");
	m[nrl] += NR_END;
	m[nrl] -= ncl;

	for(i=nrl+1;i<=nrh;i++) m[i]=m[i-1]+ncol;

	/* return pointer to array of pointers to rows */
	return m;
}

void free_ivector(int *v, long nl, long nh)
/* free an int vector allocated with ivector() */
{
	free((FREE_ARG) (v+nl-NR_END));
}
