/**********************************************************
                                 Dec. 12, 2001  Shin Satoh
FUNCTION: int rho_param()
SOURCE FILE: rho_param.c
PURPOSE: Calculate the vertical profile of rho or vratio

CALLING SEQUENCE:
    (I) float *rho_km       : air density at every km
    (I) float *vratio_km    : velocity ratios at every km
    (I) float &nadir_angle  : nadir angle (deg)
    (O) float *rho          : air density corresponding with range bins
    (O) float *vratio       : velocity ratio corresponding with range bins
RETURN: normal=0
************************************************************/
#include <math.h>
#include <stdio.h>

int rho_param(float *rho_km, float *vratio_km, float nadir_angle, 
              float *rho, float *vratio)
{
    int    i,i1,i2,k,kp1;
    static float DegToRad = 1.745329e-2;  /* degrees into radians */
    float  fraction, costh;    
    float  htkm,vratio_check;   

/* ------- air density & velocity ratio in 250 m interval ------ */ 
    costh = cos(nadir_angle*DegToRad);

    for(i=0; i<80; i++){
       htkm = i*0.25*costh;
       k =(int)htkm;
       kp1 = k+1;
       fraction = (htkm-(float)k)/(float)(kp1-k);
       rho[i] = rho_km[k] + (rho_km[kp1]-rho_km[k])*fraction;
       vratio[i] = vratio_km[k] + (vratio_km[kp1]-vratio_km[k])*fraction;
       vratio_check=pow(rho_km[0]/rho[i],0.4);
       printf("# %2d: vratio at %6.3f km  table=%7.4f  re-calc=%7.4f\n",
                 i,htkm,vratio[i],vratio_check);
    }

/*
    for(k=0; k<20; k++) {
       kp1 = k+1;
       i1 = k*4;
       i2 = kp1*4;
       for(i=i1; i<i2; i++) {
          fraction = (float)(i1-i)/(float)(i2-i1);
          rho[i] = rho_km[k] + (rho_km[kp1]-rho_km[k])*fraction;
          vratio[i] = vratio_km[k] + (vratio_km[kp1]-vratio_km[k])*fraction;
          vratio_check=pow(rho_km[0]/rho[i],0.4);
          printf("# vratio at %5.2f km  table=%7.4f  re-calc=%7.4f\n",
                  i*0.25,vratio[i],vratio_check);
       }
    }
*/
    return 0;
}


