/*----------------------------------------------------------------------
      File name:      smooth.c      for glhret.c
      Function name: smooth2d
                     smooth2d_z
                     smooth1d_y
	                             Dec. 18, 2001  by Shin Satoh
----------------------------------------------------------------------*/
#include <stdio.h>
#include <string.h>

#define   YDIM     49
#define   ZDIM     80
#define   UNDEF    -999.9

/*----------------------------------------------------------------------
      Function name: smooth2d
----------------------------------------------------------------------*/
int smooth2d (float s0[][YDIM])
{
  int         j,k,jj,kk;
  float	      s1[ZDIM][YDIM];
  float       sum,wt;

/* Input array */
       for(j=0; j<YDIM; j++){
       for(k=0; k<ZDIM; k++){
          s1[k][j] = s0[k][j];
       }}

/* weighting average (UNDEF should be UNDEF) */
       for(j=1; j<YDIM-1; j++){
       for(k=1; k<ZDIM-1; k++){
	 sum = 0.0;
         wt = 0.0;
         for(jj=j-1; jj<=j+1; jj++){
         for(kk=k-1; kk<=k+1; kk++){
           if(s0[kk][jj] > UNDEF){
	     if(jj==j && kk==k){
               sum+=s0[kk][jj]*4.0;
               wt+=4.0;
	     }else{
               sum+=s0[kk][jj]*1.0;
               wt+=1.0;
	     }
           }
	 }}
	 if(wt>=4.0) s1[k][j]=sum/wt;
       }}

/* retrieve values */
       for(j=0; j<YDIM; j++){
       for(k=0; k<ZDIM; k++){
         s0[k][j] = s1[k][j];
       }}

       return 0;
}

/*----------------------------------------------------------------------
      Function name: smooth_z
----------------------------------------------------------------------*/
int smooth2d_z (float s0[][YDIM])
{
  int         j,k,jj,kk;
  float	      s1[ZDIM];
  float       sum,wt;


    for(j=0; j<YDIM; j++){

/* Input array */
       for(k=0; k<ZDIM; k++){
          s1[k] = s0[k][j];
       }

/* weighting average (UNDEF should be UNDEF) */
       for(k=1; k<ZDIM-1; k++){
	 sum = 0.0;
         wt = 0.0;
         for(kk=k-1; kk<=k+1; kk++){
           if(s0[kk][j] > UNDEF){
	     if(kk==k){
               sum+=s0[kk][j]*1.0;
               wt+=1.0;
	     }else{
               sum+=s0[kk][j]*1.0;
               wt+=1.0;
	     }
           }
	 }
	 if(wt>=2.0) s1[k]=sum/wt;
       }

/* retrieve values */
       for(k=0; k<ZDIM; k++){
         s0[k][j] = s1[k];
       }
    }
       return 0;
}

/*----------------------------------------------------------------------
      Function name: smooth_y
----------------------------------------------------------------------*/
int smooth1d_y (float *s0)
{
  int         j,jj;
  float	      s1[YDIM];
  float       sum,wt;

/* Input array */
       for(j=0; j<YDIM; j++){
          s1[j] = s0[j];
       }

/* weighting average (UNDEF should be UNDEF) */
       for(j=1; j<YDIM-1; j++){
	 sum = 0.0;
         wt = 0.0;
         for(jj=j-1; jj<=j+1; jj++){
           if(s0[jj] > UNDEF){
	     if(jj==j){
               sum+=s0[jj]*1.0;
               wt+=1.0;
	     }else{
               sum+=s0[jj]*1.0;
               wt+=1.0;
	     }
           }
	 }
	 if(wt>=2.0) s1[j]=sum/wt;
       }

/* retrieve values */
       for(j=0; j<YDIM; j++){
         s0[j] = s1[j];
       }

       return 0;
}
