*----------------------------------------------------------
*  GrADS script for landscape
*                              Dec 19, 2001  Shin Satoh
*----------------------------------------------------------
function orbit (args)

'reinit'  
'open icephys-ave.ctl'
'set vpage 0 11 0 8.5'
'set mproj off'
'set grads off'
* xlopts color thickness LabelSize
'set xlopts 1 4 0.14'
'set ylopts 1 4 0.14'
'set gxout shaded'

*----- Upper left (tlh) -----
'set x 400 800'
'set y 3'
'set z 1 66'

'set parea 1 5 5.5 7.5'
'set clevs -15 -10 -5 0 5 10 15 20'
'set rbcols 5 11 4 9 3 10 7 12 8 2'
'd tlh'
'run cbarn_biglabel 0.5 1 5.2 6.5'
'set string 1 tl 8'
'set strsiz 0.18'
'draw string 1.2 7.4 LH (thermo) [K/hr]   (a)'

*------- Middle left (tlh) ----------------
'set parea 1 5 3.0 5.0'
'set clevs -15 -10 -5 0 5 10 15 20'
'set rbcols 5 11 4 9 3 10 7 12 8 2'
'd tlh5'
'run cbarn_biglabel 0.5 1 5.2 4.0'
'set string 1 tl 8'
'set strsiz 0.18'
'draw string 1.2 4.9 LH <10 km avg>      (b)'

*------- Bottom left (tlh) ----------------
'set parea 1 5 0.5 2.5'
'set clevs -15 -10 -5 0 5 10 15 20'
'set rbcols 5 11 4 9 3 10 7 12 8 2'
'd tlh10'
'run cbarn_biglabel 0.5 1 5.2 1.5'
'set string 1 tl 8'
'set strsiz 0.18'
'draw string 1.2 2.4 LH <20 km avg>     (c)'


*================================================*/
'open fosquall-lha.ctl'
'set dfile 2'
'set x 400 800'
'set y 3'
'set z 1 66'

'set ylopts 1 4 0.01'
*----- Upper right (lhh) -----
'set parea 6 10 5.5 7.5'
'set clevs -15 -10 -5 0 5 10 15 20'
'set rbcols 5 11 4 9 3 10 7 12 8 2'
'd lhh(t=1)'
'run cbarn_biglabel 0.5 1 10.2 6.5'
'set string 1 tl 8'
'set strsiz 0.18'
'draw string 6.2 7.4 LH (micro) [K/hr]    (d)'

*----- middle right (lhh) -----
'set parea 6 10 3.0 5.0'
'set clevs -15 -10 -5 0 5 10 15 20'
'set rbcols 5 11 4 9 3 10 7 12 8 2'
'd lhh5(t=1)'
'run cbarn_biglabel 0.5 1 10.2 4.0'
'set string 1 tl 8'
'set strsiz 0.18'
'draw string 6.2 4.9 LH <10 km avg>      (e)'

*----- Bottom right (lhh) -----
'set parea 6 10 0.5 2.5'
'set clevs -15 -10 -5 0 5 10 15 20'
'set rbcols 5 11 4 9 3 10 7 12 8 2'
'd lhh10(t=1)'
'run cbarn_biglabel 0.5 1 10.2 1.5'
'set string 1 tl 8'
'set strsiz 0.18'
'draw string 6.2 2.4 LH <20 km avg>     (f)'

'run print_ps zlhprof_satoh'
'run print_gmf zlhprof_satoh'
