*----------------------------------------------------------
*  GrADS script for landscape
*                               July 17, 2002  Shin Satoh
*----------------------------------------------------------
function orbit (args)

'reinit'  
if (args='')
  say 'usage: >grads -lc "run zlhret_along1 xxx [not include .ctl] angbin"'  
  say 'ex) x2a25_8329 22 (OK-SL)'
  say 'ex) x2a25_15423 27 (Hymalaya)'
  say 'ex) x2a25_15432 26 (Typhoon0008)'
  say 'ex) x2a25_14492 27 (Baiu)'
  say 'ex) x2a25_10464 14 (Shallow)'
  say 'Enter ctl file [without extension]:'
  pull args
endif
ctlname = subwrd(args,1)%'.ctl'
fname   = subwrd(args,1)%'_along'
angbin  = subwrd(args,2)
if (angbin='')
  angbin=24
endif
say 'ang bin= 'angbin

'open 'ctlname
'set vpage 0 11 0 8.5'
'set mproj off'
'set grads off'
* xlopts color thickness LabelSize
'set xlopts 1 4 0.12'
'set ylopts 1 4 0.12'
'set gxout shaded'
*'set gxout grfill'

*----- Upper left (rain) -----
'set y 'angbin
'set z 1 57'
'set t 1 101'
'set xaxis 0 400 50'
'set yaxis 0 14 2'

'set parea 1 5 5.5 7.5'
'set clevs 0.5 1 2 5 10 20 50'
'd maskout(rain,qp)'
'run cbarn_biglabel 0.5 1 5.2 6.5'
'set string 1 tl 8'
'set strsiz 0.18'
'draw string 1.2 7.4 Rain [mm/hr]        (a)'

*----- Middle left (Vt) -----
'set parea 1 5 3.0 5.0'
'set rbcols 9 14 4 11 5 3 10 7'
'set clevs -10 -8 -6 -5 -4 -3 -2'
'd maskout(vt,qp)'
*'set clevs -7 -6 -5 -4 -3 -2 -1'
*'d maskout(vt0,qp)'
'run cbarn_biglabel 0.5 1 5.2 4.0'
'set string 1 tl 8'
'set strsiz 0.18'
'draw string 1.2 4.9 Vt [m/s]            (b)'

*------- Bottom left (w) ----------------
'set parea 1 5 0.5 2.5'
'set clevs -2 -1 -0.5 0 0.5 1 2 5 10'
'set rbcols 5 11 4 9 3 10 7 12 8 2 6'
'd maskout(w,qp)'
'run cbarn_biglabel 0.5 1 5.2 1.5'
'set string 1 tl 8'
'set strsiz 0.18'
'draw string 1.2 2.4 w [m/s]             (c)'

*----- Upper right (Fqp) -----
'set parea 6 10 5.5 7.5'
'set rbcols 5 11 4 9 3 10 7 12 8 2'
'set clevs -3 -2 -1 0 1 2 3 4 5'
'd fqp*1e6'
'run cbarn_biglabel 0.5 1 10.2 6.5'
'set string 1 tl 8'
'set strsiz 0.18'
'draw string 6.2 7.4 Fqp [mg/kg/s]       (d)'

*----- middle right (LH) -----
'set parea 6 10 3.0 5.0'
'set clevs -15 -10 -5 0 5 10 15 20 25'
'set rbcols 5 11 4 9 3 10 7 12 8 2'
'd lh'
'run cbarn_biglabel 0.5 1 10.2 3.8'
'set string 1 tl 8'
'set strsiz 0.18'
'draw string 6.2 4.9 LH [K/hr]            (f)'


*** average of LH-profile in Conv. Strat, Anvil)
'set t 1 101'
'set y 1 49'
'set z 1 57'
'define rconv =maskout(f_wtype(z=1),1.5-f_wtype(z=1))'
'define rconv =maskout(rconv,f_wtype(z=1)-0.5)'
'define rstrat=maskout(f_wtype(z=1),2.5-f_wtype(z=1))'
'define rstrat=maskout(rstrat,f_wtype(z=1)-1.5)'
'define ranvil=maskout(f_wtype(z=1),3.5-f_wtype(z=1))'
'define ranvil=maskout(ranvil,f_wtype(z=1)-2.5)'
'define rwarm =maskout(f_wtype(z=1),4.5-f_wtype(z=1))'
'define rwarm =maskout(rwarm,f_wtype(z=1)-3.5)'

*---- special for shallow (x2a25_10464) ----*
*'define rconv =maskout(rconv,6.0-cldt(z=1))'
*'define rstrat =maskout(rstrat,6.0-cldt(z=1))'
*'define ranvil =maskout(ranvil,6.0-cldt(z=1))'
*'define rwarm =maskout(rwarm,4.0-cldt(z=1))'

say '# end of maskout rtype'

'define lh=maskout(lh,rain-0.5)'
'define lh=maskout(lh,50.0-lh)'
'define lh=maskout(lh,lh+30.0)'
'define lhconv=maskout(lh,rconv)'
'define lhstrat=maskout(lh,rstrat)'
'define lhanvil=maskout(lh,ranvil)'
'define lhwarm=maskout(lh,rwarm)'
say '# end of maskout lh'

'set y 1'
'define lhyavec=ave(lhconv,y=1,y=49)'
'define lhyaves=ave(lhstrat,y=1,y=49)'
'define lhyavea=ave(lhanvil,y=1,y=49)'
'define lhyavew=ave(lhwarm,y=1,y=49)'
say '# end of y-ave calc'

'set t 1'
'define lhavec=ave(lhyavec,t=1,t=101)'
'define lhaves=ave(lhyaves,t=1,t=101)'
'define lhavea=ave(lhyavea,t=1,t=101)'
'define lhavew=ave(lhyavew,t=1,t=101)'
say '# end of t-ave calc'

*----- Bottom right (LH-prof) -----
*---to reset xaxis --- 
'set vpage 0 11 0 8.5'
'set yaxis 0 14 2'

'set parea 6 10 0.5 2.5'
'set t 1'
'set y 1'
'set z 1 57'
'set vrange -20 20'
'set cmark 0'
'set ccolor 2'
'd lhavec'
'set cmark 0'
'set ccolor 11'
'd lhaves'
'set cmark 0'
'set ccolor 9'
'd lhavea'
'set cmark 0'
'set ccolor 3'
'd lhavew'
'set line 1 1 4'
'draw line 8.0 0.5 8.0 2.5'

'set string 1 tl 8'
'set strsiz 0.18'
'draw string 6.2 2.4 Averaged LH [K/hr]   (j)'
'set strsiz 0.15'
'set string 2 tl 8'
'draw string 6.2 2.1 CONV'
'set string 11 tl 8'
'draw string 6.2 1.9 STRAT'
'set string 9 tl 8'
'draw string 6.2 1.7 ANVIL'
'set string 3 tl 8'
'draw string 6.2 1.5 SHALLOW'

'run print_ps 'fname
*'run print_gmf 'fname
