*----------------------------------------------------------
*  GrADS script for landscape
*                               July 17, 2002  Shin Satoh
*----------------------------------------------------------
function orbit (args)

'reinit'  
if (args='')
  say 'usage: >grads -lc "run zlhret_along1 xxx [not include .ctl] angbin"'  
  say 'ex) x2a25_8329 22 (OK-SL)'
  say 'ex) x2a25_15423 27 (Hymalaya)'
  say 'ex) x2a25_15432 26 (Typhoon0008)'
  say 'ex) x2a25_14492 27 (Baiu)'
  say 'ex) x2a25_10464 14 (Shallow)'
  say 'Enter ctl file [without extension]:'
  pull args
endif
ctlname = subwrd(args,1)%'.ctl'
fname   = subwrd(args,1)%'_1'
angbin  = subwrd(args,2)
if (angbin='')
  angbin=24
endif
say 'ang bin= 'angbin

'open 'ctlname
'set vpage 0 11 0 8.5'
'set mproj off'
'set grads off'
* xlopts color thickness LabelSize
'set xlopts 1 4 0.12'
'set ylopts 1 4 0.12'
'set gxout shaded'

'set y 'angbin
'set z 1 57'
'set t 1 101'
'set xaxis 0 400 50'
'set yaxis 0 14 2'

*----- Upper left (ze) -----
'set parea 1 5 5.5 7.5'
'set clevs 15 20 25 30 35 40 45'
'd maskout(ze,qp)'
'run cbarn_biglabel 0.5 1 5.2 6.5'
'set string 1 tl 8'
'set strsiz 0.18'
'draw string 1.2 7.4 Ze [dBZ]            (a)'

*----- Middle left (rain) -----
'set parea 1 5 3.0 5.0'
'set clevs 0.5 1 2 5 10 20 50'
'd maskout(rain,qp)'
'run cbarn_biglabel 0.5 1 5.2 4.0'
'set string 1 tl 8'
'set strsiz 0.18'
'draw string 1.2 4.9 Rain [mm/hr]        (b)'

*----- Bottom left (wtype & sfcR) -----
'set vpage 0 11 0 8.5'
'set grads off'
'set xaxis 0 400 50'
'set z 1'

'set parea 1 5 1.8 2.5'
'set gxout line'
'set vrange -0.5 6.0'
'set ccolor 1'
'set cmark 5'
'set ylevs 0 1 2 3 4'
'd f_wtype'
'set string 1 tl 8'
'set strsiz 0.18'
'draw string 4.55 2.45 (c)'
'set strsiz 0.16'
'draw string 1.2 2.45 Wtype'
'set strsiz 0.10'
'draw string 1.9 2.4 (1:Conv,2:Strat,3:Anvil,4:Shallow)'

'set parea 1 5 0.5 1.5'
'set vrange 0 150.0'
'set ylevs 0 30 60 90 120 150'
'set ccolor 1'
'set cmark 0'
'set cthick 6'
'd sfcr'
'set string 1 tl 8'
'set strsiz 0.18'
'draw string 1.2 1.45 Surf Rain [mm/hr]   (d)'

*----- Upper right (vt) -----
'set vpage 0 11 0 8.5'
'set grads off'
'set xaxis 0 400 50'
'set yaxis 0 14 2'
'set z 1 57'

'set parea 6 10 5.5 7.5'
'set rbcols 9 14 4 11 5 3 10 7'
*'set clevs -7 -6 -5 -4 -3 -2 -1'
*'d maskout(vt0,qp)'
'set clevs -10 -8 -6 -5 -4 -3 -2'
'd maskout(vt,qp)'
'run cbarn_biglabel 0.5 1 10.2 6.5'
'set string 1 tl 8'
'set strsiz 0.18'
'draw string 6.2 7.4 vt [m/s]            (e)'

*----- middle right (w) -----
'set parea 6 10 3.0 5.0'
'set clevs -2 -1 -0.5 0 0.5 1 2 5 10'
'set rbcols 5 11 4 9 3 10 7 12 8 2 6'
'd maskout(w,qp)'
'run cbarn_biglabel 0.5 1 10.2 4.0'
'set string 1 tl 8'
'set strsiz 0.18'
'draw string 6.2 4.9 w [m/s]             (f)'

*----- Bottom right (LH) -----
'set parea 6 10 0.5 2.5'
'set clevs -15 -10 -5 0 5 10 15 20 25'
'set rbcols 5 11 4 9 3 10 7 12 8 2'
'd lh'
'run cbarn_biglabel 0.5 1 10.2 1.4'
'set string 1 tl 8'
'set strsiz 0.18'
'draw string 6.2 2.4 LH [K/hr]           (g)'


'run print_ps 'fname
*'run print_gmf 'fname
