*----------------------------------------------------------
*  GrADS script for landscape
*                               July 17, 2002  Shin Satoh
*----------------------------------------------------------
function orbit (args)

'reinit'  
if (args='')
  say 'usage: >grads -lc "run zlhret_along1 xxx [not include .ctl] angbin"'  
  say 'ex) x2a25_8329 22 (OK-SL)'
  say 'ex) x2a25_15423 27 (Hymalaya)'
  say 'ex) x2a25_15432 26 (Typhoon0008)'
  say 'ex) x2a25_14492 27 (Baiu)'
  say 'ex) x2a25_10464 14 (Shallow)'
  say 'Enter ctl file [without extension]:'
  pull args
endif
ctlname = subwrd(args,1)%'.ctl'
fname   = subwrd(args,1)%'_2'
angbin  = subwrd(args,2)
if (angbin='')
  angbin=24
endif
say 'ang bin= 'angbin

'open 'ctlname
'set vpage 0 11 0 8.5'
'set mproj off'
'set grads off'
* xlopts color thickness LabelSize
'set xlopts 1 4 0.12'
'set ylopts 1 4 0.12'
'set gxout shaded'
*'set gxout grfill'

'set y 'angbin
'set z 1 57'
'set t 1 101'
'set xaxis 0 400 50'
'set yaxis 0 14 2'

*----- Upper left (qp) -----
'set parea 1 5 5.5 7.5'
'set clevs 0.1 0.2 0.5 1 2 5'
'd qp*1e3'
'run cbarn_biglabel 0.5 1 5.2 6.5'
'set string 1 tl 8'
'set strsiz 0.18'
'draw string 1.2 7.4 qp [g/kg]           (a)'

*----- Middle left (Fqp) -----
'set parea 1 5 3.0 5.0'
'set clevs -3 -2 -1 0 1 2 3 4 5'
'set rbcols 5 11 4 9 3 10 7 12 8 2'
'd fqp*1e6'
'run cbarn_biglabel 0.5 1 5.2 4.0'
'set string 1 tl 8'
'set strsiz 0.18'
'draw string 1.2 4.9 Fqp [mg/kg/s]      (b)'

*------- Bottom left (LH) ------------
'set parea 1 5 0.5 2.5'
'set clevs -15 -10 -5 0 5 10 15 20 25'
'set rbcols 5 11 4 9 3 10 7 12 8 2'
'd lh'
'run cbarn_biglabel 0.5 1 5.2 1.5'
'set string 1 tl 8'
'set strsiz 0.18'
'draw string 1.2 2.4 LH [K/hr]           (c)'


*----- Upper right (Horiz_Rain) -----
'set t 1 101'
'set y 1 49'
'set z 1'

'set parea 6 10 5.5 7.5'
'set xyrev on'
'set yaxis 0 200 50'
'set clevs 0.5 1 2 5 10 20 50 100'
'd sfcr'
'run cbarn_biglabel 0.5 1 10.2 6.5'
'set string 1 tl 8'
'set strsiz 0.18'
'draw string 6.2 7.4 NearSurf Rain        (d)'

*----- middle right (wtype) -----
'set parea 6 10 3.0 5.0'
'set gxout grfill'
'set clevs 0 1 2 3'
'set rbcols 0 2 5 9 3'
'd f_wtype'
'run cbarn_biglabel 0.5 1 10.2 3.8'
'set string 1 tl 8'
'set strsiz 0.18'
'draw string 9.50 4.95 (e)'
'set strsiz 0.16'
'draw string 6.1 4.95 Wtype'
'set strsiz 0.12'
'draw string 7.0 4.9 [conv/strat/anvil/warm]'


*** average of LH-profile in Conv. Strat, Anvil)
'set t 1 101'
'set y 1 49'
'set z 1 57'
'define rconv =maskout(f_wtype(z=1),1.5-f_wtype(z=1))'
'define rconv =maskout(rconv,f_wtype(z=1)-0.5)'
'define rstrat=maskout(f_wtype(z=1),2.5-f_wtype(z=1))'
'define rstrat=maskout(rstrat,f_wtype(z=1)-1.5)'
'define ranvil=maskout(f_wtype(z=1),3.5-f_wtype(z=1))'
'define ranvil=maskout(ranvil,f_wtype(z=1)-2.5)'
'define rwarm =maskout(f_wtype(z=1),4.5-f_wtype(z=1))'
'define rwarm =maskout(rwarm,f_wtype(z=1)-3.5)'
say '# end of maskout rtype'

'define lh=maskout(lh,rain-0.5)'
'define lh=maskout(lh,50.0-lh)'
'define lh=maskout(lh,lh+30.0)'
'define lhconv=maskout(lh,rconv)'
'define lhstrat=maskout(lh,rstrat)'
'define lhanvil=maskout(lh,ranvil)'
'define lhwarm=maskout(lh,rwarm)'
say '# end of maskout lh'

'set y 1'
'define lhyavec=ave(lhconv,y=1,y=49)'
'define lhyaves=ave(lhstrat,y=1,y=49)'
'define lhyavea=ave(lhanvil,y=1,y=49)'
'define lhyavew=ave(lhwarm,y=1,y=49)'
say '# end of y-ave calc'

'set t 1'
'define lhavec=ave(lhyavec,t=2,t=98)'
'define lhaves=ave(lhyaves,t=2,t=98)'
'define lhavea=ave(lhyavea,t=2,t=98)'
'define lhavew=ave(lhyavew,t=2,t=98)'
say '# end of t-ave calc'

*----- Bottom right (LH-prof) -----
*---for 'set xyrev off' and reset xaxis --- 
'set vpage 0 11 0 8.5'

'set parea 6 10 0.5 2.5'
'set ylevs 0 2 4 6 8 10 12 14'
'set xaxis -20 20 5'
'set yaxis 0 14 2'

'set t 1'
'set y 1'
'set z 1 57'
'set vrange -20 20'
'set cmark 0'
'set ccolor 2'
'd lhavec'
'set cmark 0'
'set ccolor 11'
'd lhaves'
'set cmark 0'
'set ccolor 9'
'd lhavea'
'set cmark 0'
'set ccolor 3'
'd lhavew'
'set line 1 1 4'
'draw line 8.0 0.5 8.0 2.5'

'set string 1 tl 8'
'set strsiz 0.18'
'draw string 6.2 2.4 Averaged LH [K/hr]   (f)'
'set strsiz 0.15'
'set string 2 tl 8'
'draw string 6.2 2.1 CONV'
'set string 11 tl 8'
'draw string 6.2 1.9 STRAT'
'set string 9 tl 8'
'draw string 6.2 1.7 ANVIL'
'set string 3 tl 8'
'draw string 6.2 1.5 SHALLOW'

'run print_ps 'fname
*'run print_gmf 'fname
