*----------------------------------------------------------
*  GrADS script for landscape
*                              Dec 19, 2001  Shin Satoh
*----------------------------------------------------------
function orbit (args)

'reinit'  
'open fosquall-lha.ctl'
'set vpage 0 11 0 8.5'
'set mproj off'
'set grads off'
* xlopts color thickness LabelSize
'set xlopts 1 4 0.14'
'set ylopts 1 4 0.14'
'set gxout shaded'

*----- Upper left (qr+qs+qh) -----
'set x 400 800'
'set y 3'
'set z 1 66'
*'set ylevs 0 2 4 6 8 10 12 14 16'

'set parea 1 5 5.5 7.5'
'set clevs 0.02 0.05 0.1 0.2 0.5 1 2'
'd pwc*1e3'
'run cbarn_biglabel 0.5 1 5.2 6.5'
'set string 1 tl 8'
'set strsiz 0.18'
'draw string 1.2 7.4 qr+qs+qh [g/kg]     (a)'

*------- Bottom left (pt) ----------------
'set parea 1 5 0.5 2.5'
'd pt'
'run cbarn_biglabel 0.5 1 5.2 1.5'
'set string 1 tl 8'
'set strsiz 0.18'
'draw string 1.2 2.4 PT [K]              (d)'


'set ylopts 1 4 0.01'
*----- Upper right (w) -----
'set parea 6 10 5.5 7.5'
'set clevs -2 -1 -0.5 0 0.5 1 2 5'
'set rbcols 5 11 4 9 3 10 7 12 8 2'
'd w'
'run cbarn_biglabel 0.5 1 10.2 6.5'
'set string 1 tl 8'
'set strsiz 0.18'
'draw string 6.2 7.4 w [m/s]             (e)'

*----- middle right (w) -----
'set parea 6 10 3.0 5.0'
'set clevs -2 -1 -0.5 0 0.5 1 2 5'
'set rbcols 5 11 4 9 3 10 7 12 8 2'
'd w5'
'run cbarn_biglabel 0.5 1 10.2 4.0'
'set string 1 tl 8'
'set strsiz 0.18'
'draw string 6.2 4.9 10 km-avg          (f)'

*----- Bottom right (w) -----
'set parea 6 10 0.5 2.5'
'set clevs -2 -1 -0.5 0 0.5 1 2 5'
'set rbcols 5 11 4 9 3 10 7 12 8 2'
'd w10'
'run cbarn_biglabel 0.5 1 10.2 1.5'
'set string 1 tl 8'
'set strsiz 0.18'
'draw string 6.2 2.4 20 km-avg          (g)'

*----- Middle left (wtype & sfcR) -----
'set ylopts 1 4 0.14'
'set parea 1 5 4.4 5.0'
'set z 1'
'set gxout line'
'set vrange 0.5 3.0'
'set ccolor 1'
'set cmark 5'
'set ylevs 0 1 2'
'd csi+1'
'set string 1 tl 8'
'set strsiz 0.18'
'draw string 4.55 4.95 (b)'
'set strsiz 0.16'
'draw string 1.2 4.95 Rtype'
'set strsiz 0.10'
'draw string 1.9 4.9 (1:Strat,2:Conv)'

'set parea 1 5 3.0 4.0'
'set vrange 0 100.0'
'set ylevs 0 20 40 60 80 100'
'set ccolor 1'
'set cmark 0'
'set cthick 6'
'd rain'
'set string 1 tl 8'
'set strsiz 0.18'
'draw string 1.2 3.95 Surf Rain [mm/hr]   (c)'
'set vrange 0 15000'

'run print_ps zwprof_satoh'
'run print_gmf zwprof_satoh'
