/**********************************************************
                                 June 19, 2002  Shin Satoh
FUNCTION: int cld_ht()
SOURCE FILE: cld_ht.c
PURPOSE: Estimate cloud top and bottom height

CALLING SEQUENCE:
    (I) float cze[][49]    : reflectivity factor [dBZ]
    (I) float *flag_wtype  : w-profile type 
                             (NO_RAIN=0., CONV=1., STRAT=2., ANVIL=3., SHALLOW=4.)
    (I/O) float *cldt      : cloud top height [km]
    (I/O) float *cldb      : cloud bottom height [km]
    (I/O) float *trop      : tropopause height [km]

RETURN: 0
************************************************************/
#include <math.h>
#include <stdio.h>

#define  YDIM      49      /* number of angle bins in output */
#define  ZDIM      80      /* number of vertical bins in output */
#define  ZRESO      0.25   /* vertical resolution in km */
#define  ZEMIN     15.0    /* minimum reflectivity [dBZ] (actually 17 dBZ, but...) */

int cld_ht (float cze[][YDIM], float *flag_wtype, 
            float *cldt, float *cldb, float *trop)
{
        int    i, j, k;
        float  ztop, zbot;

    /* get tropopause height */
        for(j=0; j<YDIM; j++){
	  trop[j]=14.0;        /* tentative !!!! */       
        }

    /* get echo top & bottom height [km] */
    /* --- should continue more than 3 range bins --- */
        for(j=0; j<YDIM; j++){
          ztop = cldt[j];
          zbot = cldb[j];
	  for(k=0; k<ZDIM-3; k++){
            if(cze[k][j]>ZEMIN &&
               cze[k+1][j]>ZEMIN &&
               cze[k+2][j]>ZEMIN   ){ 
                 ztop = (k+2)*ZRESO; 
            }
          }
          if(0.9<flag_wtype[j] && flag_wtype[j]<1.1) ztop +=0.25;  /* conv */
          if(1.9<flag_wtype[j] && flag_wtype[j]<2.1) ztop +=1.0;   /* strat */
          if(2.9<flag_wtype[j] && flag_wtype[j]<3.1) ztop +=1.0;   /* anvil */
          if(3.9<flag_wtype[j] && flag_wtype[j]<4.1) ztop +=0.25;  /* shallow */
          if(trop[j] < ztop) trop[j] = ztop + 0.25;      /* penetrative conv */
          cldt[j]=ztop;

	  for(k=ZDIM-1; k>1; k--){
            if(cze[k][j]>ZEMIN &&
               cze[k-1][j]>ZEMIN &&
               cze[k-2][j]>ZEMIN   ){ 
                 zbot = (k-2)*ZRESO; 
            }
          }
          cldb[j]=zbot;
       }

       return 0;     
}
