/*----------------------------------------------------------------------
	                               July 02, 2002  by Shin SATOH

      File name:      ggrads_ctl.c       for < glhret_v4.1.c >
      Function name:  ggrads_ctl

         g_name      : output file name
         nx,ny,nz,nt : dimensions of x,y,z and t
         x,y,z,tmin  : min. values of x,y,z 
                       and time[min] (after the start time in header)
         dx,dy,dz,dt : grid intervals of x,y,z and t[min]
         c_var       : variable names ("ze,vr,u,...")
         c_memo      : for TITLE in the GrADS_ctl file

         return(0)   : normal return
         return(1)   : output file (*.ctl) cannot be opened 

	                ver. 1.4   June 27, 2002  by Shinsuke SATOH
----------------------------------------------------------------------*/
#include <stdio.h>
#include <string.h>

int ggrads_ctl (char *g_name, int nx, int ny, int nz, int nt,
                double xmin, double ymin, double zmin, double tmin,
                double dx, double dy, double dz, double dt, double no_data,
                int ihour, int imin, int iday, int imonth, int iyear,
                char *c_var, char *c_memo)
{
	FILE	     *fpc;
	static char  c_name[64];
	static char  *var[100];        /* max 100 variables */
        static char  s_blank[100][10];
        int          i=0,j,k=0,var_num,slen;
        int          ihr,hr1,hr2,mi1,mi2,dy1,dy2,imon,idt;
        static int   var_zdim[400];
        static char  *cmon[12]={"JAN","FEB","MAR","APR","MAY","JUN",
                               "JUL","AUG","SEP","OCT","NOV","DEC"};

/* Output file open */
        strcpy(c_name,g_name);  strcat(c_name,".ctl");
	if((fpc = fopen(c_name,"w" )) == NULL ){
	    printf("File not open ! : %s \n",c_name); 
            return(1);
        }

/* get time value for TDEF */
        hr1 = ihour / 10;   hr2 = ihour - (hr1 * 10);
        mi1 = imin / 10;    mi2 = imin - (mi1 * 10);
        dy1 = iday / 10;    dy2 = iday - (dy1 * 10);
        imon = imonth - 1;
        idt = (int)dt;    /* min. in unit */

/* get variable name for VARS */
        var[0] = &c_var[0];  k=1;  i=1;
	while (c_var[i] != '\0'){
	   if (c_var[i] == ','){
              c_var[i] = '\0';
	      var[k] = &c_var[i+1];
	      k++;
	   }
	   i++;
	   if (i > 398){
              printf(" over dimension of VARS !\n");
	      break;
	   }
	}
	var_num = k;

/* set zdim of variables */
        for (k=0; k < var_num; k++){
	   var_zdim[k]=nz;
	   if (strcmp(var[k],"stime")==0) var_zdim[k]=1;
	   if (strcmp(var[k],"slat")==0) var_zdim[k]=1;
	   if (strcmp(var[k],"slon")==0) var_zdim[k]=1;
	   if (strcmp(var[k],"sfcz")==0) var_zdim[k]=1;
	   if (strcmp(var[k],"sfcr")==0) var_zdim[k]=1;
	   if (strcmp(var[k],"avgsfcr")==0) var_zdim[k]=1;
	   if (strcmp(var[k],"stmht")==0) var_zdim[k]=1;
	   if (strcmp(var[k],"clfht")==0) var_zdim[k]=1;
	   if (strcmp(var[k],"sfcht")==0) var_zdim[k]=1;
	   if (strcmp(var[k],"bbht")==0) var_zdim[k]=1;
	   if (strcmp(var[k],"trop")==0) var_zdim[k]=1;
	   if (strcmp(var[k],"cldt")==0) var_zdim[k]=1;
	   if (strcmp(var[k],"cldb")==0) var_zdim[k]=1;
	   if (strncmp(var[k],"f_",2)==0) var_zdim[k]=1;

	   slen=10-strlen(var[k]);
	   for(j=0; j<slen; j++) strncat(&s_blank[k][0]," ",1);
           /* printf("## k=%2d  slen=%3d  %s|\n",k,slen,s_blank[k]); */
	}

/* output contol file */
	fprintf(fpc,"DSET      ^%s\n",g_name);
	fprintf(fpc,"TITLE     %s\n",c_memo);
	fprintf(fpc,"UNDEF     %4.1e\n",no_data);
        fprintf(fpc,"XDEF      %5d LINEAR  %7.2f  %7.3f\n",nx,xmin,dx);
        fprintf(fpc,"YDEF      %5d LINEAR  %7.2f  %7.3f\n",ny,ymin,dy);
        fprintf(fpc,"ZDEF      %5d LINEAR  %7.2f  %7.3f\n",nz,zmin,dz);
        fprintf(fpc,"TDEF      %5d LINEAR  %1d%1d:%1d%1dZ%1d%1d%3s%4d  %dmn\n",
                nt,hr1,hr2,mi1,mi2,dy1,dy2,cmon[imon],iyear,idt);
	fprintf(fpc,"VARS      %d\n",var_num);
        for (k=0; k < var_num; k++){
	   fprintf(fpc,"%s%s  %3d   99   %s\n",var[k],s_blank[k],var_zdim[k],var[k]);
	}
	fprintf(fpc,"ENDVARS\n");
        fclose(fpc);

/* print contol file */
	printf("DSET      ^%s\n",g_name);
	printf("TITLE     %s\n",c_memo);
	printf("UNDEF     %4.1e\n",no_data);
        printf("XDEF      %5d LINEAR  %7.2f  %7.3f\n",nx,xmin,dx);
        printf("YDEF      %5d LINEAR  %7.2f  %7.3f\n",ny,ymin,dy);
        printf("ZDEF      %5d LINEAR  %7.2f  %7.3f\n",nz,zmin,dz);
        printf("TDEF      %5d LINEAR  %1d%1d:%1d%1dZ%1d%1d%3s%4d  %dmn\n",
                nt,hr1,hr2,mi1,mi2,dy1,dy2,cmon[imon],iyear,idt);
	printf("VARS      %d\n",var_num);
        for (k=0; k < var_num; k++){
	   printf("%s%s %3d   99   %s\n",var[k],s_blank[k],var_zdim[k],var[k]);
	}
	printf("ENDVARS\n");

        printf("\n  output GrADS ctl file: %s\n",c_name);
	return(0);
}
