/**************************************************************
                                  June 27, 2002  Shin Satoh
SOURCE FILE: glhret_v4.0.h
PURPOSE:     to define the function prototypes used in
             glhret_v4.0.c
***************************************************************/
#define  N5         5      /* number of nodes for LWC-Z relations */
#define  NFNAME   100      /* number of characters for a file name */
#define  YDIM      49      /* number of angle bins in output */

int read_param(char init_file[NFNAME], 
               float zl_a_c0[][N5], float zl_a_c1[][N5], float zl_a_c2[][N5], 
               float zl_b_c0[][N5], float zl_b_c1[][N5], float zl_b_c2[][N5],
	       float *rho_km, float *tempa_km, float *press_km, float *vratio_km);

int read_trop(char init_file[NFNAME], int imonth, float *month_trop);

int air_param(float *press_km, float *tempa_km, float *rho_km, 
              float *vratio_km, float *press, float *tempa, 
              float *qvs, float *rho, float *vratio);

int wc_param(int *rbinNum, int raintype, int flag_warm, float zl_a_c0[][N5],  
             float zl_a_c1[][N5], float zl_a_c2[][N5], float zl_b_c0[][N5],  
             float zl_b_c1[][N5], float zl_b_c2[][N5], float nubfCFzl,  
             float epsilonf, float wght_ZR_corr, int *rbinZRNode, 
             float *a, float *b);

int cld_ht (float cze[][YDIM], float *flag_wtype, float *slat,  
            float *month_trop, float *trop, float *cldt, float *cldb);

int lh_prof (float *rho, float *qvs, 
             float qp[][YDIM], float vt[][YDIM], float vt0[][YDIM],
             float *sfcr, float *sfcht, float *bbht,
             float *trop, float *cldt, float *cldb, float *flag_wtype, 
             float w[][YDIM], float fqp[][YDIM], float lh[][YDIM],
             float *flag_iter);

int ggrads_ctl(char *g_name, int nx, int ny, int nz, int nt,
               double xmin, double ymin, double zmin, double tmin,
               double dx, double dy, double dz, double dt, double no_data,
               int ihour, int imin, int iday, int imonth, int iyear,
               char *c_var, char *c_memo);

int w4pf_prof(double zt, double zc, double zm, float *coef);
