/**********************************************************
                                 Dec. 12, 2001  Shin Satoh
FUNCTION: int read_param()
SOURCE FILE: read_param.c
PURPOSE: Read in the initial parameters for glhret.c

Original Code by T. Iguchi (2A25 Version 6.3)

CALLING SEQUENCE:
    (I) int   init_file[NFNAME]  : parameter file name
    (O) float zl_a_c0[][5]  : a in R = a * Z^b
    (O) float zl_a_c1[][5]  : a = 10^(a_c0+a_c1*x+a_c2*x^2)
    (O) float zl_a_c2[][5]  :   where x = log10(epsilon) 
    (O) float zl_b_c0[][5]  : b in R = a * Z^b
    (O) float zl_b_c1[][5]  : b = 10^(b_c0+b_c1*x+b_c2*x^2)
    (O) float zl_b_c2[][5]  :   where x = log10(epsilon)
    (O) float *rho          : air density at 21 heights
    (O) float *tempa        : air temparature at 21 heights
    (O) float *press        : pressure at 21 heights
    (O) float *vratio       : velocity ratios at 21 heights
RETURN: 0
NOTE: Each line in the data file consists of four fields:
    enumeration, parameter value, parameter name, and comments.

    The enumeration number in each line is read, but ignored.  
    It is only for easy reference.  The parameter names written 
    in the data file must be exactly the same as those in this file.   
    Comments are totally ignored.  Anything after the third entry
    in each line are regarded as comments.  You do not need to 
    enclose the comments by special symbols.
************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define N3 3
#define N5 5
#define N21 21
#define NFNAME 100

int read_param(char init_file[NFNAME], 
        float zl_a_c0[][N5], float zl_a_c1[][N5], float zl_a_c2[][N5], 
        float zl_b_c0[][N5], float zl_b_c1[][N5], float zl_b_c2[][N5],
        float *rho, float *tempa, float *press, float *vratio)
{

    FILE *fp;
    char dummy[200],dum1[100];
    int  ii,i,j,k,status;
    char vname[20];    /* variable name */

    status = 0;

    /* open the parameter file */
    if( (fp = fopen(init_file,"r")) == NULL){
         printf("File open error. %s\n",init_file);
         return 99;
    }
    
    /* skip the first 4 lines */
    for(i=0;i<4;i++) {
        fgets(dummy,sizeof(dummy),fp);
    }
    

    for(ii=0;ii<N3;ii++) {  /* ii means raintype (STRAT, CONV, OTHERS) */
        fgets(dummy,sizeof(dummy),fp); /* skip 1 line */

    /* read LWC-Ze coefficients */
        fgets(dummy,sizeof(dummy),fp); /* skip 1 line */
        for(i=0;i<N5;i++) {
            fgets(dummy,sizeof(dummy),fp);
            sscanf(dummy,"%d%f%s",&j,zl_a_c0[ii]+i,dum1);
            sprintf(vname,"zl_a_c0[%d][%d]",ii,i);
            if(strcmp(vname,dum1) != 0) { 
                printf("Mismatch: %s %s\n",vname,dum1);  
                status++; 
            }
        }
        fgets(dummy,sizeof(dummy),fp); /* skip 1 line */
        for(i=0;i<N5;i++) {
            fgets(dummy,sizeof(dummy),fp);
            sscanf(dummy,"%d%f%s",&j,zl_a_c1[ii]+i,dum1);
            sprintf(vname,"zl_a_c1[%d][%d]",ii,i);
            if(strcmp(vname,dum1) != 0) { 
                printf("Mismatch: %s %s\n",vname,dum1);  
                status++; 
            }
        }
        fgets(dummy,sizeof(dummy),fp); /* skip 1 line */
        for(i=0;i<N5;i++) {
            fgets(dummy,sizeof(dummy),fp);
            sscanf(dummy,"%d%f%s",&j,zl_a_c2[ii]+i,dum1);
            sprintf(vname,"zl_a_c2[%d][%d]",ii,i);
            if(strcmp(vname,dum1) != 0) { 
                printf("Mismatch: %s %s\n",vname,dum1);  
                status++; 
            }
        }
        fgets(dummy,sizeof(dummy),fp); /* skip 1 line */
        for(i=0;i<N5;i++) {
            fgets(dummy,sizeof(dummy),fp);
            sscanf(dummy,"%d%f%s",&j,zl_b_c0[ii]+i,dum1);
            sprintf(vname,"zl_b_c0[%d][%d]",ii,i);
            if(strcmp(vname,dum1) != 0) { 
                printf("Mismatch: %s %s\n",vname,dum1);  
                status++; 
            }
        }
        fgets(dummy,sizeof(dummy),fp); /* skip 1 line */
        for(i=0;i<N5;i++) {
            fgets(dummy,sizeof(dummy),fp);
            sscanf(dummy,"%d%f%s",&j,zl_b_c1[ii]+i,dum1);
            sprintf(vname,"zl_b_c1[%d][%d]",ii,i);
            if(strcmp(vname,dum1) != 0) { 
                printf("Mismatch: %s %s\n",vname,dum1);  
                status++; 
            }
        }
        fgets(dummy,sizeof(dummy),fp); /* skip 1 line */
        for(i=0;i<N5;i++) {
            fgets(dummy,sizeof(dummy),fp);
            sscanf(dummy,"%d%f%s",&j,zl_b_c2[ii]+i,dum1);
            sprintf(vname,"zl_b_c2[%d][%d]",ii,i);
            if(strcmp(vname,dum1) != 0) { 
                printf("Mismatch: %s %s\n",vname,dum1);  
                status++; 
            }
        }
    }

    /* read general parameter */
    for(i=0;i<2;i++) fgets(dummy,sizeof(dummy),fp); /* skip 2 line */
    for(i=0;i<N21;i++) {
        fgets(dummy,sizeof(dummy),fp);
        sscanf(dummy,"%d%f%s",&j,rho+i,dum1);
        sprintf(vname,"rho[%d]",i);
        if(strcmp(vname,dum1) != 0) { 
            printf("Mismatch: %s %s\n",vname,dum1);  
            status++; 
        }
    }

    fgets(dummy,sizeof(dummy),fp); /* skip 1 line */
    for(i=0;i<N21;i++) {
        fgets(dummy,sizeof(dummy),fp);
        sscanf(dummy,"%d%f%s",&j,tempa+i,dum1);
        sprintf(vname,"tempa[%d]",i);
        if(strcmp(vname,dum1) != 0) { 
            printf("Mismatch: %s %s\n",vname,dum1);  
            status++; 
        }
    }

    fgets(dummy,sizeof(dummy),fp); /* skip 1 line */
    for(i=0;i<N21;i++) {
        fgets(dummy,sizeof(dummy),fp);
        sscanf(dummy,"%d%f%s",&j,press+i,dum1);
        sprintf(vname,"press[%d]",i);
        if(strcmp(vname,dum1) != 0) { 
            printf("Mismatch: %s %s\n",vname,dum1);  
            status++; 
        }
    }

    fgets(dummy,sizeof(dummy),fp); /* skip 1 line */
    for(i=0;i<N21;i++) {
        fgets(dummy,sizeof(dummy),fp);
        sscanf(dummy,"%d%f%s",&j,vratio+i,dum1);
        sprintf(vname,"vratio[%d]",i);
        if(strcmp(vname,dum1) != 0) { 
            printf("Mismatch: %s %s\n",vname,dum1);  
            status++; 
        }
    }

    return status;
}

