/**********************************************************
                                 Dec. 13, 2001  Shin Satoh
FUNCTION: int air_param()
SOURCE FILE: air_param.c
PURPOSE: Calculate the vertical profile of pressure, 
         temparature, qvs, rho, and vratio

CALLING SEQUENCE:
    (I) float *press_km     : air pressure at every km
    (I) float *tempa_km     : air temparature at every km
    (I) float *rho_km       : air density at every km
    (I) float *vratio_km    : velocity ratios at every km
    (O) float *press        : air pressure in range bins
    (O) float *tempa        : air temparature in 80 range bins
    (O) float *qvs          : saturated mixing ratio of vapar in range bins
    (O) float *rho          : air density in range bins
    (O) float *vratio       : velocity ratio in range bins
RETURN: normal=0
************************************************************/
#include <math.h>
#include <stdio.h>

int air_param(float *press_km, float *tempa_km, float *rho_km, 
              float *vratio_km, float *press, float *tempa, 
              float *qvs, float *rho, float *vratio)
{
    int    i,i1,i2,k,kp1;
    float  fraction, xtempC, xes, vratio_table;    
    double xrho_ratio;

/* ------- air density & velocity ratio in 250 m interval ------ */ 
    for(k=0; k<20; k++) {
       kp1 = k+1;
       i1 = k*4;
       i2 = kp1*4;
       for(i=i1; i<i2; i++) {
          fraction = (float)(i-i1)/(float)(i2-i1);
          press[i] = press_km[k] + (press_km[kp1]-press_km[k])*fraction;
          tempa[i] = tempa_km[k] + (tempa_km[kp1]-tempa_km[k])*fraction;
          xtempC = tempa[i] - 273.15;
          xes=6.1078*pow(10.0,(7.5*xtempC/(237.3+xtempC)));                           
          qvs[i]=0.622*xes/(press[i]-0.378*xes);

          rho[i] = rho_km[k] + (rho_km[kp1]-rho_km[k])*fraction;
          vratio_table = vratio_km[k] + (vratio_km[kp1]-vratio_km[k])*fraction;
          xrho_ratio=(double)rho_km[0]/rho[i];
          vratio[i]=pow(xrho_ratio,0.4);

#ifdef DEBUG
          printf("#%2d: %5.2f km  press=%7.2f  tempa=%7.3f  qvs=%7.4f  ",
                  i,i*0.25,press[i],tempa[i],qvs[i]*1000.);
          printf("  rho=%7.4f  vratio table=%7.4f  re-calc=%7.4f\n",
                  rho[i],vratio_table,vratio[i]);
#endif

       }
    }

    return 0;
}


