/**********************************************************
                                 June 25, 2002  Shin Satoh
FUNCTION: int read_trop()
SOURCE FILE: read_trop.c
PURPOSE: Read in the tropopause heights for glhret.c

CALLING SEQUENCE:
    (I) int   init_file[NFNAME]  : the trop_ht file name
    (I) int   imonth             : the monnth (1 to 12)
    (O) float month_trop[33]     : monthly tropopause height
RETURN: Mismatched data number
        88 means abnormal month, 99 means not found the file
NOTE: Each line in the data file consists of four fields:
    enumeration, parameter value, parameter name, and comments.
************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define N3 3
#define N5 5
#define N21 21
#define N33 33
#define NFNAME 100

int read_trop(char init_file[NFNAME], int imonth, float *month_trop) 
{

    FILE *fp;
    char dummy[200],dum1[100];
    int  ii,i,j,k,status;
    char vname[20];    /* variable name */

    status = 0;

    /* check the month */
    if(imonth<1 || imonth>12){
       printf("abnormal month data: %d\n",imonth);
       return 88;
    }

    /* open the parameter file */
    if((fp = fopen(init_file,"r")) == NULL){
       return 99;
    }
    
    /* skip the first 7 lines */
    for(i=0;i<7;i++) {
       fgets(dummy,sizeof(dummy),fp);
    }
    
    /* skip the before the month data */
    for(ii=0;ii<imonth-1;ii++){
       fgets(dummy,sizeof(dummy),fp); /* skip 1 line */
       for(i=0;i<N33;i++) {
          fgets(dummy,sizeof(dummy),fp);
       }
    }

    /* read the height data */
    fgets(dummy,sizeof(dummy),fp); /* skip 1 line */
    for(i=0;i<N33;i++) {
        fgets(dummy,sizeof(dummy),fp);
        sscanf(dummy,"%d%f%s",&j,month_trop+i,dum1);
	/* printf("READ: %d  %f  %s\n",j,month_trop[i],dum1); */
        sprintf(vname,"month_trop[%d][%d]",imonth-1,i);
        if(strcmp(vname,dum1) != 0) { 
            printf("Mismatch: %s %s on the line %d\n",vname,dum1,j);  
            status++; 
        }
    }

    return status;
}

