*----------------------------------------------------------
*  GrADS script for landscape
*                              July 17, 2002  Shin Satoh
*----------------------------------------------------------
function main (args)

'reinit'
if (args='')
  say 'Enter ctl file:'
  say 'ex) z3a25_199805.ctl'
  pull args
endif
'open 'args

'set vpage 0 11 0 8.5'
'set grads off'
'set gxout grfill'
'set lat -40 40'
'set z 1'
'define totalr=dn_conv+dn_strat+dn_anvil+dn_shall'

*--- percent of data num ---
'set parea 0.5 5.5 6.6 8.0'
'set ylab on'
'set clevs 10 20 30 40 50 60 70 80 90'
'd (dn_strat/totalr)*100.'
*'set clevs 1 2 3 4 5 6 7 8 9 10'
*'d (dn_strat/dn_total)*100.'

'set parea 5.7 10.7 6.6 8.0'
'set ylab off'
'set clevs 10 20 30 40 50 60 70 80 90'
'd (dn_conv/totalr)*100.'
*'set clevs 1 2 3 4 5 6 7 8 9 10'
*'d (dn_conv/dn_total)*100.'

'set parea 0.5 5.5 5.0 6.4'
'set ylab on'
'set clevs 10 20 30 40 50 60 70 80 90'
'd (dn_anvil/totalr)*100.'
*'set clevs 1 2 3 4 5 6 7 8 9 10'
*'d (dn_anvil/dn_total)*100.'

'set parea 5.7 10.7 5.0 6.4'
'set ylab off'
'set clevs 10 20 30 40 50 60 70 80 90'
'd (dn_shall/totalr)*100.'
*'set clevs 1 2 3 4 5 6 7 8 9 10'
*'d (dn_shall/dn_total)*100.'

'run cbarn 0.7 0 5.25 4.6'

*--- percent of rain ---
'set parea 0.5 5.5 2.4 3.8'
'set ylab on'
'set clevs 10 20 30 40 50 60 70 80 90'
'd (strat*dn_strat)/(sfcr*dn_sfcr)*100.'

'set parea 5.7 10.7 2.4 3.8'
'set ylab off'
'set clevs 10 20 30 40 50 60 70 80 90'
'd (conv*dn_conv)/(sfcr*dn_sfcr)*100.'

'set parea 0.5 5.5 0.8 2.2'
'set ylab on'
'set clevs 10 20 30 40 50 60 70 80 90'
'd (anvil*dn_anvil)/(sfcr*dn_sfcr)*100.'

'set parea 5.7 10.7 0.8 2.2'
'set ylab off'
'set clevs 10 20 30 40 50 60 70 80 90'
'd (shall*dn_shall)/(sfcr*dn_sfcr)*100.'

'run cbarn 0.7 0 5.25 0.4'

'set string 1 bc 8'
'set strsiz 0.22'
'draw string 5.25 8.1 RAINTYPE PERCENTAGE for DATA NUM'
'draw string 5.25 3.9 RAINTYPE PERCENTAGE for RAINFALL'

'set string 1 tl 8'
'set strsiz 0.14'
'draw string 0.55 7.9 STRAT'
'draw string 5.75 7.9 CONV'
'draw string 0.55 6.3 ANVIL'
'draw string 5.75 6.3 SHALL'

'draw string 0.55 3.7 STRAT'
'draw string 5.75 3.7 CONV'
'draw string 0.55 2.1 ANVIL'
'draw string 5.75 2.1 SHALL'

return
